import zmq
from my_point_pb2 import Point

context = zmq.Context()
port_subscriber = "2000"
socket_subscriber = context.socket(zmq.SUB)
socket_subscriber.connect(f"tcp://127.0.0.1:{port_subscriber}")  # Make sure to use the same address as the sender
socket_subscriber.setsockopt(zmq.SUBSCRIBE, b"")

serialized_data = socket_subscriber.recv()
point = Point()
point.ParseFromString(serialized_data)
print("Received Point:")
print(f"Point: x={point.x}, y={point.y}, z={point.z}")

